// models/Territory.js
import mongoose from 'mongoose';

const territorySchema = new mongoose.Schema({
  name: {
    type: String,
    required: true,
    trim: true,
  },
  division: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Division',
    required: true,
  },
  subdivision: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Subdivision',
  },
  geometry: {
    type: {
      type: String,
      enum: ['Polygon'],
      required: true,
    },
    coordinates: {
      type: [[[Number]]],
      required: true,
    },
  },
});

territorySchema.index({ geometry: '2dsphere' });

export default mongoose.model('Territory', territorySchema);